*
* This is a sample program startup that determines if a user has a RIPscrip 
* capable terminal program, and if so, sets RIPscrip = .T., otherwise it 
* makes RIPscrip = .F.
*
* This code fragment is released to the public domain for use in any TDBS
* applications as needed.
*

*
* Assume that we should keep it turned off to start
*
RIPscrip = .F.

*
* The following string sends a RIPscrip "query text variable" command.
* We do not actually query a variable, but instead ask for the program to
* return RIP^M.  If we receive that string, we know the terminal package is
* RIPscrip capable.
*
? '!|1'+CHR(27)+'0000RIP`M'+CHR(13)+CHR(12)

*
* There are two ways to accept the possible responses.  The first method is
* "safest", but requires a user to enter a keystroke.  Since most TDBS
* applications ask for a key to be pressed before starting, this will not
* look odd to the user.
*
?? "Press [Enter] to start program..."

*
* Now accept the user response.  In the case of a RIPscrip terminal program,
* The response will be RIP, while in other cases it will NOT be "RIP"
*
ACCEPT TO resp

*
* Instead of the above printout and ACCEPT statements, the program could
* go into a loop looking for characters.  If none were received within a
* fairly short period of time, then it could be assumed that the program
* is NOT RIPscrip capable.  This method is much more prone to error since
* line delays could cause the program to make the wrong decision.  Line
* delays are prevalent on X.25 links (like PC-Pursuit), as well as when
* high speed modems retrain because of bad line conditions.
*
* The last method is to use the "loop input" method described above, in
* conjunction with the RIPscrip ANSI code <esc>[! which will return 
* "RIPSCRIPxxxxxx" where the x's correspond to a RIPscrip version number.
* This method has the failing of causing some terminal programs to do odd
* things with the ANSI code which is non-standard, as well as the failing
* of needing the timing loop which can generate an incorrect answer.
*
* The method shown as best can only fail in the case where a user types in
* "RIP" instead of just pressing [Enter] (in which case the user was kind
* of silly to start with), or when line noise interrupts the "RIP" string.
* If line noise is interrupting the RIP string, then it is very likely that
* line noise would cause the RIP graphics to produce odd results and not
* using RIPscrip in that case is probably the best choice.
*

*
* Now clear the screen again in case the RIPscrip program sent data
*
?? CHR(12)

IF resp = "RIP"
  RIPscrip = .T.		&& He has RIPscrip capability
ENDIF

*
* At this point the program has determined RIPscrip capability and can use
* the RIPscrip memvar to do different things for a RIP user.
*

*
* Now, just to check (plug in real program code starting here)
*
IF RIPscrip
  ? "Program is RIPscrip capable"
ELSE
  ? "Program is NOT RIPscrip capable"
ENDIF

WAIT
